/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package viewer;

import java.awt.BorderLayout;
import java.io.IOException;
import java.net.URISyntaxException;

import javax.swing.JFrame;

import com.inet.report.EngineRenderData;
import com.inet.viewer.RenderData;
import com.inet.viewer.SwingReportViewer;

/**
 * This sample demonstrates how you can display more than one report with multiple tabs in i-net Clear Reports viewer.
 * This is accomplished simply by calling "addNewReportView" more than once.
 */
public class MultipleReportsView extends JFrame {

    private RenderData        renderConnection;  // This is our main render data connection - the source of our raw report data coming from our report server

    private RenderData        renderConnection2; // This is our render data connection for the second report- the source of our raw report data coming from our report server

    private SwingReportViewer viewer;            // Our top-level viewer object

    /**
     * Displays more than one report with multiple tabs in the Java viewer.
     */
    public MultipleReportsView() {
        super( "i-net Clear Reports - Multiple Reports View" );
        // to initialize we first create a top level ReportViewer:
        viewer = new SwingReportViewer();

        String reportLocation = "";
        String report2Location = "";
        try {
            reportLocation = getClass().getResource( "../sample.rpt" ).toURI().toString();
            report2Location = getClass().getResource( "../sample.rpt" ).toURI().toString();
        } catch( URISyntaxException e ) {
            // Nothing to do
        }

        // then initialize the render data connection.
        renderConnection = new EngineRenderData( "report=" + reportLocation );
        renderConnection2 = new EngineRenderData( "report=" + report2Location );

        // you will most likely have a report server already, so you can use the URL: http://server:port/report.rpt
        // renderConnection = new URLRenderData( "http://server:port/?report=file:c:/report1.rpt" );
        // renderConnection2 = new URLRenderData( "http://localhost:9000/?report=file:c:/report2.rpt" );

        // addNewReportView causes a new report view to be created using the given connection as its data source, and then
        // for this newly created report to be added to the viewer.
        viewer.addNewReportView( renderConnection );

        // addNewReportView causes a new report view to be created using the given connection as its data source, and then
        // for this newly created report to be added to the viewer.
        viewer.addNewReportView( renderConnection2 );

        // add the viewer to the target window
        getContentPane().add( BorderLayout.CENTER, viewer );

        pack();
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     * @throws IOException in case of IO errors. Often the port is already in use.
     */
    public static void main( String[] args ) throws IOException {
        (new MultipleReportsView()).setVisible( true );
    }
}
